import 'package:cool_dropdown/widgets/marquee_widget.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viser_remit/core/utils/my_images.dart';
import 'package:viser_remit/data/controller/home/home_controller.dart';
import 'package:viser_remit/data/controller/send_money/send_money_controller.dart';
import 'package:viser_remit/data/model/send_money/send_money_model.dart';
import 'package:viser_remit/view/screens/bottom_nav_section/home/widget/form_section/receive_currency_field.dart';
import 'package:viser_remit/view/screens/send_money/widget/limit_bottom_sheet.dart';

import '../../../core/utils/dimensions.dart';
import '../../../core/utils/my_color.dart';
import '../../../core/utils/my_strings.dart';
import '../../../core/utils/style.dart';
import '../../../core/utils/util.dart';
import '../../../data/repo/send_money/send_money_repo.dart';
import '../../../data/services/api_client.dart';
import '../../components/app-bar/viser_remit_app_bar.dart';
import '../../components/bottom-sheet/custom_bottom_sheet.dart';
import '../../components/buttons/rounded_button.dart';
import '../../components/custom_loader/custom_loader.dart';
import '../../components/text-form-field/custom_drop_down_button_with_text_field2.dart';
import '../bottom_nav_section/home/widget/form_section/send_currency_field.dart';

class SenderScreen extends StatefulWidget {
  const SenderScreen({super.key});

  @override
  State<SenderScreen> createState() => _SenderScreenState();
}

class _SenderScreenState extends State<SenderScreen> with SingleTickerProviderStateMixin {
  TabController? tabController;

  @override
  void initState() {
    Get.put(ApiClient(sharedPreferences: Get.find()));
    Get.put(SendMoneyRepo(apiClient: Get.find()));
    final controller = Get.put(SendMoneyController(sendMoneyRepo: Get.find()));
    tabController = TabController(length: 2, vsync: this, initialIndex: 0);
    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      controller.loadSendMoneyData();
    });
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<SendMoneyController>(
      builder: (controller) => GetBuilder<HomeController>(
        builder: (homeController) => Scaffold(
          appBar: ViserRemitAppBar(
            title: MyStrings.senderInformation.tr,
            isElevation: true,
          ),
          body: controller.isLoading
              ? const CustomLoader()
              : SingleChildScrollView(
                  physics: const BouncingScrollPhysics(),
                  padding: const EdgeInsets.symmetric(horizontal: Dimensions.space16, vertical: Dimensions.space15),
                  child: Container(
                    padding: const EdgeInsetsDirectional.symmetric(horizontal: Dimensions.space15, vertical: Dimensions.space15),
                    decoration: BoxDecoration(
                      borderRadius: BorderRadius.circular(Dimensions.space10),
                      color: MyColor.getCardBgColor(),
                      boxShadow: MyUtils.getCardShadow(),
                    ),
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        const SizedBox(height: Dimensions.space26),
                        Text(MyStrings.youSend.tr, style: semiBoldDefault.copyWith(fontSize: 13, color: MyColor.body2)),
                        const SizedBox(height: Dimensions.space8),
                       SendCurrencyField(enableOptionalItem: homeController.enableSendMoneyScreenOptionalItem),
                        const SizedBox(height: 12),
                        GestureDetector(
                          onTap: () {
                            CustomBottomSheet(child: LimitBottomSheet(controller: controller)).customBottomSheet(context);
                          },
                          child: Row(
                            mainAxisAlignment: MainAxisAlignment.start,
                            children: [
                              const Icon(
                                Icons.info_outline,
                                size: 20,
                              ),
                              const SizedBox(
                                width: 5,
                              ),
                              Text(
                                MyStrings.limit.tr,
                                style: mediumLarge,
                              ),
                              const SizedBox(
                                width: 10,
                              ),
                              if (controller.limitOver())
                                Expanded(
                                  child: MarqueeWidget(
                                    child: Text(
                                      MyStrings.limitMSg.tr,
                                      overflow: TextOverflow.ellipsis,
                                      maxLines: 1,
                                      style: mediumLarge.copyWith(color: MyColor.colorRed),
                                    ),
                                  ),
                                ),
                            ],
                          ),
                        ),
                        const SizedBox(height: 12),
                        Text(MyStrings.recipientGets.tr, style: semiBoldDefault.copyWith(fontSize: 13, color: MyColor.body2)),
                        const SizedBox(height: Dimensions.space8),
                        ReceiveCurrencyField(enableOptionalItem: homeController.enableSendMoneyScreenOptionalItem),
                        const SizedBox(
                          height: Dimensions.space16,
                        ),
                        homeController.selectedSendCountry.id == -1 || homeController.selectedReceiveCountry.id == -1 ? const SizedBox() : Center(child: Text("1 ${homeController.selectedSendCountry.currency ?? ''} = ${homeController.selectedSendCountry.conversionRates != null &&homeController.selectedSendCountry.conversionRates!.isNotEmpty  ? homeController.getRateByCountryIds(
                              homeController.selectedSendCountry.conversionRates,
                            ) : homeController.getInitialCurrencyRate()} ${homeController.selectedReceiveCountry.currency ?? ''}", style: boldExtraLarge)),
                        const SizedBox(height: Dimensions.space32),
                        CustomDropDownTextField2(
                          fillColor: MyColor.textFieldColor,
                          labelText: MyStrings.sourceOfFund.tr,
                          selectedValue: controller.selectedSourceOfFunds,
                          onChanged: (value) {
                            controller.setSelectedSourceOfFunds(value);
                          },
                          items: controller.sourceOfFundsList.map((Sources method) {
                            return DropdownMenuItem<Sources>(
                              value: method,
                              child: Text((method.name ?? '').tr, style: regularDefault.copyWith(color: MyColor.getTextColor())),
                            );
                          }).toList(),
                        ),
                        const SizedBox(height: Dimensions.space16),
                        CustomDropDownTextField2(
                          fillColor: MyColor.textFieldColor,
                          labelText: MyStrings.sendingPurpose.tr,
                          selectedValue: controller.selectedPurpose,
                          onChanged: (value) {
                            controller.setSelectedPurpose(value);
                          },
                          items: controller.purposeList.map((Purposes method) {
                            return DropdownMenuItem<Purposes>(
                              value: method,
                              child: Text((method.name ?? '').tr, style: regularDefault.copyWith(color: MyColor.getTextColor())),
                            );
                          }).toList(),
                        ),
                        const SizedBox(height: Dimensions.space32),
                         Text(MyStrings.paymentVia.tr, style: mediumLarge),
                        const SizedBox(height: Dimensions.space12),
                        Container(
                          padding: const EdgeInsets.all(6),
                          decoration: BoxDecoration(color: MyColor.primaryColor.withOpacity(.05), borderRadius: BorderRadius.circular(16)),
                          child: TabBar(
                            labelColor: MyColor.colorBlack,
                            automaticIndicatorColorAdjustment: true,
                            controller: tabController,
                            unselectedLabelColor: MyColor.colorBlack,
                            indicator: BoxDecoration(color: MyColor.colorWhite, borderRadius: BorderRadius.circular(12)),
                            indicatorColor: MyColor.primaryColor,
                            labelStyle: boldLarge,
                            onTap: (value) {
                              int selectedValue = value + 1;
                              controller.setSelectedPaymentType(selectedValue.toString());
                            },
                            tabs: [
                              Row(
                                children: [
                                  Image.asset(MyImages.refundWalletPng),
                                  const SizedBox(width: Dimensions.space8),
                                   Expanded(
                                    child: Tab(
                                      text: MyStrings.refundWallet.tr,
                                    ),
                                  ),
                                ],
                              ),
                              Row(
                                children: [
                                  Image.asset(MyImages.directPaymentPng),
                                  const SizedBox(width: Dimensions.space8),
                                  Expanded(
                                    child: Tab(
                                      text: MyStrings.directPayment.tr,
                                    ),
                                  ),
                                ],
                              ),
                            ],
                          ),
                        ),
                        const SizedBox(height: Dimensions.space25),
                        RoundedButton(
                          fontSize: 16,
                          verticalPadding: 15,
                          text: MyStrings.continueText.tr,
                          press: () {
                            controller.goToRecipientScreen();
                          },
                        ),
                      ],
                    ),
                  ),
                ),
        ),
      ),
    );
  }
}
